# SPDX-FileCopyrightText: 2023 Liz Clark for Adafruit Industries
# SPDX-FileCopyrightText: Adapted from Phil B.'s 16bit_hello Arduino Code
# SPDX-License-Identifier: MIT
# Updated 2026 at Iffy Books, wtfpl

import os
import gc

import time
import displayio
import picodvi
import board
import framebufferio
import terminalio
import simpleio
from adafruit_bitmap_font import bitmap_font
from adafruit_display_text import label, wrap_text_to_lines

# pin defs for DVI Sock
displayio.release_displays()
fb = picodvi.Framebuffer(320, 240,
	clk_dp=board.GP14, clk_dn=board.GP15,
	red_dp=board.GP12, red_dn=board.GP13,
	green_dp=board.GP18, green_dn=board.GP19,
	blue_dp=board.GP16, blue_dn=board.GP17,
	color_depth=8)
display = framebufferio.FramebufferDisplay(fb)

red = 0xff0000
yellow = 0xcccc00
orange = 0xff5500
blue = 0x0000ff
pink = 0xff00ff
purple = 0x5500ff
white = 0xffffff
green =  0x00ff00
aqua = 0x125690

palette = displayio.Palette(3)
palette[0] = 0x000000 # black
palette[1] = white
palette[2] = yellow

palette.make_transparent(0)

group = displayio.Group()

def clean_up(group_name):
    for _ in range(len(group_name)):
        group_name.pop()
    gc.collect()


def custom_font():
    gc.collect()
    
    text_paths = ['/text/'+filename for filename in os.listdir('/text') if filename[0]!='.']
    
    text_paths = sorted(text_paths)
    
    title_card = True
    
    for text_path in text_paths:
        
        with open(text_path) as fi:
            text_sample = fi.read()
        
        #text_sample = "The Product of Television. Commercial Television. Is the Audience."
        
        my_font = bitmap_font.load_font("/Helvetica-Bold-16.pcf")
        text_sample = "\n".join(wrap_text_to_lines(text_sample, 28))
        

        sample_text = label.Label(my_font, text=text_sample)
        sample_text.anchor_point = (0.5, 0.5)
        sample_text.anchored_position = (display.width / 2, display.height / 2)

        group.append(sample_text)

        time.sleep(4.9)
        
        if title_card:
            time.sleep(8.5)
            title_card = False
            
        
        clean_up(group)

        gc.collect()

display.root_group = group

while True:
    custom_font()
    #bitmap_example()
    #text_align()
    #show_shapes()
    #sine_chart()
    #widget0()
    #widget1()
    #sensor_values()
