# SPDX-FileCopyrightText: 2023 Liz Clark for Adafruit Industries
# SPDX-FileCopyrightText: Adapted from Phil B.'s 16bit_hello Arduino Code
# SPDX-License-Identifier: MIT
# Updated 2026 at Iffy Books, wtfpl

import gc
import time
import displayio
import picodvi
import board
import framebufferio

# pin defs for DVI Sock
displayio.release_displays()
fb = picodvi.Framebuffer(320, 240,
	clk_dp=board.GP14, clk_dn=board.GP15,
	red_dp=board.GP12, red_dn=board.GP13,
	green_dp=board.GP18, green_dn=board.GP19,
	blue_dp=board.GP16, blue_dn=board.GP17,
	color_depth=8)
display = framebufferio.FramebufferDisplay(fb)

bitmap = displayio.Bitmap(display.width, display.height, 3)

group = displayio.Group()

def clean_up(group_name):
    for _ in range(len(group_name)):
        group_name.pop()
    gc.collect()

def display_bitmap(path_name):
    gc.collect()
    blinka_bitmap = displayio.OnDiskBitmap(path_name)
    blinka_grid = displayio.TileGrid(blinka_bitmap, pixel_shader=blinka_bitmap.pixel_shader)
    gc.collect()
    group.append(blinka_grid)

    time.sleep(60)
    clean_up(group)

    del blinka_grid
    del blinka_bitmap
    gc.collect()


display.root_group = group

while True:
    display_bitmap("/first_website.bmp")
    display_bitmap("/writing_room.bmp")

